<?php
/**
 * @copyright Copyright 2003-2025 Zen Cart Development Team
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version Modern Dynamic Dashboard 2026
 * @author ZenExpert - https://zenexpert.com
 */

require_once DIR_WS_CLASSES . 'currencies.php';
$currencies ??= new currencies();

// make sure Dashboard Layout Config exists
if(!defined('DASHBOARD_WIDGETS_CONFIG')) {
    $db->Execute("INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Dashboard Layout Config', 'DASHBOARD_WIDGETS_CONFIG', '', 'JSON data for dashboard layout', 6, 0, NOW());");
}

// pre-fetch key metrics for KPI cards
// we keep these hardcoded as they are specific to the header design
$orders_today = $db->Execute("select count(*) as count from " . TABLE_ORDERS . " where date_purchased > '" . date('Y-m-d') . "'");
$revenue_today = $db->Execute("select sum(value) as total from " . TABLE_ORDERS_TOTAL . " ot left join " . TABLE_ORDERS . " o on o.orders_id = ot.orders_id where o.date_purchased > '" . date('Y-m-d') . "' AND ot.class = 'ot_total'");
$customers_today = $db->Execute("select count(*) as count from " . TABLE_CUSTOMERS_INFO . " where customers_info_date_account_created > '" . date('Y-m-d') . "'");
$reviews_pending = $db->Execute("select count(*) as count from " . TABLE_REVIEWS . " where status = 0");

// zone definitions
// each zone is an array of widget file paths to include
// layout zones:
// - main:    The big column on the left (9/12 width)
// - sidebar: The narrow column on the right (3/12 width)
// - bottom:  Full width row at the bottom (12/12 width)
$default_zones = [
    'main' => [
        'SalesReportDashboardWidget.php',
        'RecentOrdersDashboardWidget.php'
    ],
    'sidebar' => [
        'OrderStatusDashboardWidget.php',
        'MostPopularProductsDashboardWidget.php',
        'WhosOnlineDashboardWidget.php'
    ],
    'bottom' => [
        'TrafficDashboardWidget.php',
        'SpecialsDashboardWidget.php',
        'BaseStatisticsDashboardWidget.php'
    ]
];

// check database for saved layout
$saved_config = defined('DASHBOARD_WIDGETS_CONFIG') ? DASHBOARD_WIDGETS_CONFIG : '';
$zones = json_decode($saved_config, true);

// if DB config is empty or invalid, use default
if (!is_array($zones) || empty($zones)) {
    $zones = $default_zones;
}

// render a zone
function render_zone($zone_name, $widgets_array)
{
    global $db, $currencies, $show_status_pills, $target_status_ids, $sniffer, $zco_notifier, $messageStack, $recentOrdersMaxRows, $target_status_ids, $show_status_pills; // Globals needed inside widgets

    echo '<ul id="zone-' . $zone_name . '" class="sortable-list list-unstyled row" style="min-height: 200px; padding-bottom: 50px;">';

    foreach ($widgets_array as $widget_file) {
        $path = DIR_WS_MODULES . 'dashboard_widgets/' . $widget_file;

        if (file_exists($path)) {

            $col_class = 'col-md-12';

            if ($zone_name == 'bottom') {
                if ($widget_file == 'TrafficDashboardWidget.php') {
                    $col_class = 'col-xs-12 col-md-6'; // traffic gets half width
                } else {
                    $col_class = 'col-xs-12 col-md-3'; // others get quarter width
                }
            }

            // data-markers for JS
            $data_attr = 'data-id="' . $widget_file . '"';
            $li_class = $col_class . ' widget-li';

            // Traffic widget - prevent it moving to sidebar
            if ($widget_file == 'TrafficDashboardWidget.php') {
                $li_class .= ' locked-bottom';
            }

            echo '<li class="' . $li_class . '" ' . $data_attr . '>';
            include $path;
            echo '</li>';
        }
    }
    echo '</ul>';
}

// Notifier for plugins to inject their own widgets into zones
$zco_notifier->notify('NOTIFY_ADMIN_DASHBOARD_ZONES', null, $zones);

?>

<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
<head>
    <?php require DIR_WS_INCLUDES . 'admin_html_head.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
</head>
<body class="indexDashboard">

<?php require(DIR_WS_INCLUDES . 'header.php'); ?>

<div class="container-fluid dashboard-wrapper">

    <div class="row">
        <div class="col-xs-6 col-lg-3">
            <div class="kpi-card bg-aqua">
                <div class="inner">
                    <h3><?php echo $orders_today->fields['count']; ?></h3>
                    <p><?php echo BOX_KPI_ORDERS_TODAY; ?></p>
                </div>
                <div class="icon"><i class="fa fa-shopping-cart"></i></div>
                <a href="<?php echo zen_href_link(FILENAME_ORDERS); ?>"
                   class="kpi-card-footer"><?php echo BOX_KPI_MORE_INFO; ?> <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-xs-6 col-lg-3">
            <div class="kpi-card bg-green">
                <div class="inner">
                    <h3><?php echo $currencies->format($revenue_today->fields['total']); ?></h3>
                    <p><?php echo BOX_KPI_REVENUE_TODAY; ?></p>
                </div>
                <div class="icon"><i class="fa fa-dollar"></i></div>
                <a href="<?php echo zen_href_link(FILENAME_STATS_SALES_REPORT_GRAPHS); ?>"
                   class="kpi-card-footer"><?php echo BOX_KPI_MORE_INFO; ?> <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-xs-6 col-lg-3">
            <div class="kpi-card bg-yellow">
                <div class="inner">
                    <h3><?php echo $customers_today->fields['count']; ?></h3>
                    <p><?php echo BOX_KPI_CUSTOMERS_TODAY; ?></p>
                </div>
                <div class="icon"><i class="fa fa-user-plus"></i></div>
                <a href="<?php echo zen_href_link(FILENAME_CUSTOMERS); ?>"
                   class="kpi-card-footer"><?php echo BOX_KPI_MORE_INFO; ?> <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <div class="col-xs-6 col-lg-3">
            <div class="kpi-card bg-red">
                <div class="inner">
                    <h3><?php echo $reviews_pending->fields['count']; ?></h3>
                    <p><?php echo BOX_KPI_REVIEWS_PENDING; ?></p>
                </div>
                <div class="icon"><i class="fa fa-comments"></i></div>
                <a href="<?php echo zen_href_link(FILENAME_REVIEWS, 'status=1'); ?>"
                   class="kpi-card-footer"><?php echo BOX_KPI_MORE_INFO; ?> <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-9">
            <?php render_zone('main', $zones['main']); ?>
        </div>

        <div class="col-md-3">
            <?php render_zone('sidebar', $zones['sidebar']); ?>
        </div>

    </div>

    <div class="row">
        <div class="col-md-12">
            <?php render_zone('bottom', $zones['bottom']); ?>
        </div>
    </div>

</div>
